set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 5.

**1. Preparing data
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	
	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	drop if D1_LP1_EMP==.

	*Standardize TFP 
	foreach var in D1_LP1_EMP {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	
	sum D1_LP1_EMP [w=weight_VA_c]

	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)
	
save $path_temp\temp_T5, replace

		
**2. Table 5, top panel
use $path_temp\temp_T5, clear
	
	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T5_$col
				lincomest D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				estimates store own_$col
				est restore T5_$col
	end		
		
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP"
	local controls1	"i.country*year i.country*i.bcycle"
	local controls2	"i.sectorgroup i.country*year i.country*i.bcycle"
	local controls3	"i.sectorgroup"


	**Panel A: Employment
		global col=1
		qui xi:areg D1_lnEMP  `own' `controls1' [w=weight_c], absorb(year) clus(ic) 
			storeestimates
		global col=2
		qui xi:areg D1_lnEMP  `own' `controls2' [w=weight_c], absorb(year) clus(ic) 
			storeestimates
		global col=3
		qui xi:areg D1_lnEMP  `own' `controls3' [w=weight_c], absorb(ct) clus(ic) 
			storeestimates
			
	**Panel B: Hours worked
		global col=4
		qui xi:areg D1_lnH_EMP  `own' `controls1' [w=weight_h_c], absorb(year) clus(ic) 
			storeestimates
		global col=5
		qui xi:areg D1_lnH_EMP  `own' `controls2' [w=weight_h_c], absorb(year) clus(ic) 
			storeestimates
		global col=6
		qui xi:areg D1_lnH_EMP  `own' `controls3' [w=weight_h_c], absorb(ct) clus(ic)
			storeestimates
			
	**Panel C: Nominal wage bill
		global col=7
		qui xi:areg D1_lnLAB  `own' `controls1' [w=weight_h_c], absorb(year) clus(ic) 
			storeestimates
		global col=8
		qui xi:areg D1_lnLAB  `own' `controls2' [w=weight_h_c], absorb(year) clus(ic) 
			storeestimates
		global col=9
		qui xi:areg D1_lnLAB  `own'   `controls3' [w=weight_h_c], absorb(ct) clus(ic) 
			storeestimates

	
	*Table 5, top panel
	esttab T5_1 T5_2 T5_3 T5_4 T5_5 T5_6 T5_7 T5_8 T5_9, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 5")
	
	foreach var in own  {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6 `var'_7 `var'_8 `var'_9, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 5")
		}	
		

**3. Table 5, bottom panel
use $path_temp\temp_T5, clear
	
	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T5_$col
				lincomest D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				estimates store own_$col
				est restore T5_$col
	end		
		
	local controls1	"i.country*year i.country*i.bcycle"
	local controls2	"i.sectorgroup i.country*year i.country*i.bcycle"
	local controls3	"i.sectorgroup"

	
	**Panel D: Nominal value added
		global col=1
		qui xi:areg D1_lnVA  `own' `controls1' [w=weight_VA_c], absorb(year) clus(ic) 
			storeestimates
		global col=2
		qui xi:areg D1_lnVA  `own' `controls2' [w=weight_VA_c], absorb(year) clus(ic) 
			storeestimates
		global col=3
		qui xi:areg D1_lnVA  `own' `controls3' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates
			
	**Panel E: Real value added
		global col=4
		qui xi:areg D1_lnVA_QI  `own' `controls1' [w=weight_VA_c], absorb(year) clus(ic) 
			storeestimates
		global col=5
		qui xi:areg D1_lnVA_QI  `own' `controls2' [w=weight_VA_c], absorb(year) clus(ic) 
			storeestimates
		global col=6
		qui xi:areg D1_lnVA_QI  `own' `controls3' [w=weight_VA_c], absorb(ct) clus(ic)
			storeestimates
			
	**Panel F: Laborshare
		global col=7
		qui xi:areg D1_lnlaborshare  `own' `controls1' [w=weight_VA_c], absorb(year) clus(ic) 
			storeestimates
		global col=8
		qui xi:areg D1_lnlaborshare  `own' `controls2' [w=weight_VA_c], absorb(year) clus(ic) 
			storeestimates
		global col=9
		qui xi:areg D1_lnlaborshare  `own'   `controls3' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates
			
	
	*Table 5, bottom panel
	esttab T5_1 T5_2 T5_3 T5_4 T5_5 T5_6 T5_7 T5_8 T5_9, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 5")
	
	foreach var in own  {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6 `var'_7 `var'_8 `var'_9, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 5")
		}
		

*erase temporary file
erase $path_temp\temp_T5.dta
